package ru.yandex.webmaster3.viewer.http.searchquery;

import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryFilter;

/**
 * @author aherman
 */
public class GetLatestQueriesRequest extends AbstractUserVerifiedHostRequest implements PagerAware {
    public static final String PARAM_GROUP_ID = "groupId";

    private String groupId;
    private ViewerQueryFilter[] filters;
    private int page = 0;
    private int pageSize = 25;

    private QueryIndicator orderBy = QueryIndicator.TOTAL_CLICKS_COUNT;
    private OrderDirection direction = OrderDirection.DESC;
    private ShowIndicator show = ShowIndicator.QUERY;

    private String[] groupIds;

    @RequestQueryProperty
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return groupId;
    }

    public String[] getGroupIds() {
        return groupIds;
    }

    @RequestPostProperty
    public void setGroupIds(String[] groupIds) {
        this.groupIds = groupIds;
    }

    @RequestPostProperty
    public void setFilters(ViewerQueryFilter[] filters) {
        this.filters = filters;
    }

    public ViewerQueryFilter[] getFilters() {
        return filters;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    @RequestQueryProperty
    public void setOrderBy(QueryIndicator orderBy) {
        this.orderBy = orderBy;
    }

    public QueryIndicator getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setDirection(OrderDirection direction) {
        this.direction = direction;
    }

    public OrderDirection getDirection() {
        return direction;
    }

    @RequestQueryProperty
    public void setShow(ShowIndicator show) {
        this.show = show;
    }

    public ShowIndicator getShow() {
        return show;
    }

    public static enum ShowIndicator {
        QUERY,
        URL
    }
}
