package ru.yandex.webmaster3.viewer.http.searchquery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jetbrains.annotations.NotNull;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.LatestSearchQuery;
import ru.yandex.webmaster3.core.searchquery.QueryId;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;

/**
 * @author aherman
 */
public abstract class GetLatestQueriesResponse implements ActionResponse {
    public static class NormalResponse extends GetLatestQueriesResponse implements ActionResponse.NormalResponse {
        private final long totalQueries;
        private final List<Query> queries;

        public NormalResponse(long totalQueries, List<Query> queries) {
            this.totalQueries = totalQueries;
            this.queries = queries;
        }

        public long getTotalQueries() {
            return totalQueries;
        }

        public List<Query> getQueries() {
            return queries;
        }
    }

    public static class NoSuchGroupResponse extends GetLatestQueriesResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return ErrorType.SEARCHQUERIES__NO_SUCH_GROUP;
        }
    }

    public static class Query {
        private final Map<QueryIndicator, Object> indicators;

        public Query(Map<QueryIndicator, Object> indicators) {
            this.indicators = indicators;
        }

        public Map<QueryIndicator, Object> getIndicators() {
            return indicators;
        }
    }

    @NotNull
    public static List<GetLatestQueriesResponse.Query> toQueries(List<LatestSearchQuery> queries,
            Map<QueryId, String> queryTexts)
    {
        List<GetLatestQueriesResponse.Query> result = new ArrayList<>();
        for (LatestSearchQuery query : queries) {
            String queryText = queryTexts.get(query.getQueryId());
            Query q = toQuery(queryText, query);
            result.add(q);
        }

        return result;
    }

    @NotNull
    public static Query toQuery(String queryText, LatestSearchQuery query) {
        Map<QueryIndicator, Object> statistics = new HashMap<>();
        statistics.put(QueryIndicator.QUERY, queryText);
        statistics.put(QueryIndicator.TOTAL_SHOWS_COUNT, query.getTotalShowsCount());
        statistics.put(QueryIndicator.TOTAL_CLICKS_COUNT, query.getTotalClicksCount());
        statistics.put(QueryIndicator.TOTAL_CTR, query.getCtrTotal());
        statistics.put(QueryIndicator.AVERAGE_SHOW_POSITION, query.getAvgShowPosition());
        statistics.put(QueryIndicator.AVERAGE_CLICK_POSITION, query.getAvgClickosition());
        return new Query(statistics);
    }

}
