package ru.yandex.webmaster3.viewer.http.searchquery;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQuery;

/**
 * @author avhaliullin
 */
public abstract class GetQueryInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetQueryInfoResponse implements ActionResponse.NormalResponse {
        private final ViewerQuery query;

        public NormalResponse(ViewerQuery query) {
            this.query = query;
        }

        public ViewerQuery getQuery() {
            return query;
        }
    }

    public enum Errors {
        GET_QUERY_INFO__QUERY_NOT_FOUND,
    }

    @Description("Запрос не найден")
    public static class QueryNotFoundError extends GetQueryInfoResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.GET_QUERY_INFO__QUERY_NOT_FOUND;
        }
    }
}
