package ru.yandex.webmaster3.viewer.http.searchquery;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.searchquery.PathId;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerPath;
import ru.yandex.webmaster3.storage.searchquery.UrlStatisticsService2;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.Collections;
import java.util.Map;

/**
 * @author lester
 */
@Description("Получить путь урла по id")
@ReadAction
@Category("searchquery")
public class GetUrlInfoAction extends AbstractUserVerifiedHostAction<GetUrlInfoRequest, GetUrlInfoResponse> {
    @Autowired
    private UrlStatisticsService2 urlStatisticsService2;

    @Override
    public GetUrlInfoResponse process(GetUrlInfoRequest request) {
        PathId pathId = request.getPathId();
        Map<PathId, String> paths = urlStatisticsService2.getPathTexts(
                request.getHostId(),
                request.getSpecialGroup(),
                Collections.singletonList(pathId)
        );
        if (!paths.containsKey(pathId)) {
            return new GetUrlInfoResponse.UrlNotFoundError();
        }
        return new GetUrlInfoResponse.NormalResponse(new ViewerPath(pathId, paths.get(pathId)));
    }
}
