package ru.yandex.webmaster3.viewer.http.searchquery;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerPath;

/**
 * @author lester
 */
public abstract class GetUrlInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlInfoResponse implements ActionResponse.NormalResponse {
        private final ViewerPath path;

        public NormalResponse(ViewerPath path) {
            this.path = path;
        }

        public ViewerPath getPath() {
            return path;
        }
    }

    public enum Errors {
        GET_URL_INFO__URL_NOT_FOUND,
    }

    @Description("Путь не найден")
    public static class UrlNotFoundError extends GetUrlInfoResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.GET_URL_INFO__URL_NOT_FOUND;
        }
    }
}
