package ru.yandex.webmaster3.viewer.http.searchquery;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.searchquery.QueryGroup;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.searchquery.QueryGroupService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.core.searchquery.viewer.QueryGroupConverter;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryGroup;

import java.util.ArrayList;
import java.util.List;

/**
 * @author aherman
 */
@ReadAction
@Category("searchquery")
@Component("/searchquery/group/list")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class ListQueryGroupAction extends AbstractUserVerifiedHostAction<ListQueryGroupRequest, ListQueryGroupResponse> {
    private final QueryGroupService queryGroupService;

    @Override
    public ListQueryGroupResponse process(ListQueryGroupRequest request) {
        List<QueryGroup> queryGroups = queryGroupService.listGroups(request.getHostId());
        List<ViewerQueryGroup> result = new ArrayList<>(queryGroups.size());

        result.add(QueryGroupConverter.toViewerGroup(SpecialGroup.ALL_QUERIES));
        result.add(QueryGroupConverter.toViewerGroup(SpecialGroup.UPLOADED_QUERIES));
        result.add(QueryGroupConverter.toViewerGroup(SpecialGroup.SELECTED_QUERIES));

        for (QueryGroup queryGroup : queryGroups) {
            ViewerQueryGroup viewerGroup = QueryGroupConverter.toViewerGroup(queryGroup);
            result.add(viewerGroup);
        }
        return new ListQueryGroupResponse.NormalReponse(result);
    }
}
