package ru.yandex.webmaster3.viewer.http.searchquery;

import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryFilter;

/**
 * @author aherman
 */
public class SaveQueryGroupRequest extends AbstractUserVerifiedHostRequest {
    public static final String PARAM_FILTERS = "filters";
    public static final String PARAM_GROUP_NAME = "groupName";

    private String groupId;

    private String groupName;
    private ViewerQueryFilter[] filters;
    private String[] addQueries;
    private String[] removeQueries;
    private String[] moveQueries;
    private String moveGroupId;

    @RequestQueryProperty
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return groupId;
    }

    @RequestQueryProperty
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return groupName;
    }

    @RequestPostProperty
    public void setFilters(ViewerQueryFilter[] filters) {
        this.filters = filters;
    }

    public ViewerQueryFilter[] getFilters() {
        return filters;
    }

    @RequestPostProperty
    public void setAddQueries(String[] addQueries) {
        this.addQueries = addQueries;
    }

    public String[] getAddQueries() {
        return addQueries;
    }

    @RequestPostProperty
    public void setRemoveQueries(String[] removeQueries) {
        this.removeQueries = removeQueries;
    }

    public String[] getRemoveQueries() {
        return removeQueries;
    }

    @RequestPostProperty
    public void setMoveQueries(String[] moveQueries) {
        this.moveQueries = moveQueries;
    }

    public String[] getMoveQueries() {
        return moveQueries;
    }

    public String getMoveGroupId() {
        return moveGroupId;
    }

    @RequestPostProperty
    public void setMoveGroupId(String moveGroupId) {
        this.moveGroupId = moveGroupId;
    }
}
