package ru.yandex.webmaster3.viewer.http.searchquery;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.QueryGroup;

import java.util.UUID;

/**
 * @author aherman
 */
public abstract class SaveQueryGroupResponse implements ActionResponse {
    public static class NormalResponse extends SaveQueryGroupResponse implements ActionResponse.NormalResponse {
        private final QueryGroup queryGroup;
        private final boolean isNew;

        public NormalResponse(QueryGroup queryGroup, boolean isNew) {
            this.queryGroup = queryGroup;
            this.isNew = isNew;
        }

        public QueryGroup getQueryGroup() {
            return queryGroup;
        }

        public boolean isNew() {
            return isNew;
        }
    }

    public static class NoSuchGroupResponse extends SaveQueryGroupResponse implements ActionResponse.ErrorResponse {
        private final String groupId;

        public NoSuchGroupResponse(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return groupId;
        }

        @Override
        public Enum<?> getCode() {
            return ErrorType.SEARCHQUERIES__NO_SUCH_GROUP;
        }
    }

    public static class GroupAlreadyExistReponse extends SaveQueryGroupResponse implements ActionResponse.ErrorResponse {
        private final String groupId;

        public GroupAlreadyExistReponse(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return groupId;
        }

        @Override
        public Enum<?> getCode() {
            return ErrorType.SEARCHQUERIES__GROUP_ALREADY_EXIST;
        }
    }

    public static class GroupLimitReachedResponse extends SaveQueryGroupResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return ErrorType.SEARCHQUERIES__GROUP_LIMIT_REACHED;
        }
    }

    public static class QueryLimitReachedResponse extends SaveQueryGroupResponse implements ActionResponse.ErrorResponse {
        private final String groupId;
        private final int queriesLeft;

        public QueryLimitReachedResponse(String groupId, int queriesLeft) {
            this.groupId = groupId;
            this.queriesLeft = queriesLeft;
        }

        public String getGroupId() {
            return groupId;
        }

        public int getQueriesLeft() {
            return queriesLeft;
        }

        @Override
        public Enum<?> getCode() {
            return ErrorType.SEARCHQUERIES__QUERY_LIMIT_REACHED;
        }
    }
}
