package ru.yandex.webmaster3.viewer.http.searchquery.recommended;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.recommendedquery.samples.RecommendedQuery;

import java.util.List;

/**
 * Created by ifilippov5 on 09.03.17.
 */
public class GetRecommendedQueryInfoResponse implements ActionResponse.NormalResponse {
    private final long totalQueries;
    private final List<RecommendedQuery> queries;
    private final boolean hasRecommendedQueries;

    public GetRecommendedQueryInfoResponse(long totalQueries, List<RecommendedQuery> queries, boolean hasRecommendedQueries) {
        this.totalQueries = totalQueries;
        this.queries = queries;
        this.hasRecommendedQueries = hasRecommendedQueries;
    }

    @Description("количество доступных примеров популярных запросов")
    public long getTotalQueries() {
        return totalQueries;
    }

    @Description("список популярных запросов")
    public List<RecommendedQuery> getQueries() {
        return queries;
    }

    @Description("")
    public boolean getHasRecommendedQueries() {
        return hasRecommendedQueries;
    }
}
