package ru.yandex.webmaster3.viewer.http.searchquery.recommended;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.recommendedquery.RecommendedQueriesService;
import ru.yandex.webmaster3.storage.recommendedquery.dao.RecommendedQueriesCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;

import java.util.Collections;
import java.util.List;

/**
 * Created by ifilippov5 on 13.03.17.
 */
@Description("Получить список регионов")
@ReadAction
@Category("recommended")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetRecommendedQueryRegionsAction extends AbstractUrlFilteringAction<GetRecommendedQueryRegionsRequest, GetRecommendedQueryRegionsResponse> {

    private final RecommendedQueriesService recommendedQueriesService;

    @Override
    public GetRecommendedQueryRegionsResponse process(GetRecommendedQueryRegionsRequest request) {
        RecommendedQueriesCHDao.Include include = request.getInclude();
        long regionsCount = recommendedQueriesService.getRegionsCount(request.getHostId(), include);
        if (regionsCount == 0) {
            return new GetRecommendedQueryRegionsResponse(regionsCount, Collections.emptyList());
        }
        List<Long> regions = recommendedQueriesService.getRegions(request.getHostId(),
                request.getP() * request.getPSize(), request.getPSize(), include);
        return new GetRecommendedQueryRegionsResponse(regionsCount, regions);
    }
}

