package ru.yandex.webmaster3.viewer.http.searchquery.recommended;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.recommendedquery.dao.RecommendedQueriesCHDao;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

/**
 * Created by ifilippov5 on 13.03.17.
 */
public class GetRecommendedQueryRegionsRequest extends UsersVerifiedHostRequest implements PagerAware {
    private int p;
    private int pSize = 10;
    private RecommendedQueriesCHDao.Include include = RecommendedQueriesCHDao.Include.BOTH;

    public RecommendedQueriesCHDao.Include getInclude() {
        return include;
    }

    @Description("Регионы каких запросов включать в результат -- с показами, без показов, или все (по умолчанию).")
    @RequestQueryProperty
    public void setInclude(RecommendedQueriesCHDao.Include include) {
        this.include = include;
    }

    @Override
    public void setP(int page) {
        p = page;
    }

    @Override
    public void setPSize(int pageSize) {
        pSize = pageSize;
    }

    public int getP() {
        return p;
    }

    public int getPSize() {
        return pSize;
    }
}
