package ru.yandex.webmaster3.viewer.http.searchquery.recommended;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.List;

/**
 * Created by ifilippov5 on 13.03.17.
 */
public class GetRecommendedQueryRegionsResponse implements ActionResponse.NormalResponse {
    private final long totalRegions;
    private final List<Long> regions;

    public GetRecommendedQueryRegionsResponse(long totalRegions, List<Long> regions) {
        this.totalRegions = totalRegions;
        this.regions = regions;
    }

    @Description("количество регионов")
    public long getTotalRegions() {
        return totalRegions;
    }

    @Description("список регионов")
    public List<Long> getRegions() {
        return regions;
    }
}
