package ru.yandex.webmaster3.viewer.http.searchquery.recommended.download;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

import java.util.List;

/**
 * Created by ifilippov5 on 20.03.17.
 */
public abstract class AbstractDownloadRecommendedQueriesRequest<I extends Enum<I>, F extends AbstractFilter<I>> extends UsersVerifiedHostRequest {
    private List<F> parameterFilters;
    private FileFormat exportFormat;

    public List<F> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по рекомендованным запросам")
    @RequestPostProperty
    public void setParameterFilters(List<F> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    @Description("формат файла выгрузки")
    @RequestQueryProperty(required = true)
    public void setExportFormat(FileFormat exportFormat) {
        this.exportFormat = exportFormat;
    }
}
