package ru.yandex.webmaster3.viewer.http.searchquery.recommended.download;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.recommendedquery.dao.RecommendedQueriesCHDao;
import ru.yandex.webmaster3.storage.recommendedquery.filtres.RecommendedQueryField;
import ru.yandex.webmaster3.storage.recommendedquery.filtres.RecommendedQueryFilter;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * Created by ifilippov5 on 20.03.17.
 */
public class DownloadRecommendedQueriesRequest extends DownloadRequest<RecommendedQueryField, RecommendedQueryFilter> {

    private Long regionId;
    private RecommendedQueryField orderBy = RecommendedQueryField.FORECASTED_CLICKS;
    private OrderBy.Direction orderDirection = OrderBy.Direction.DESC;
    private RecommendedQueriesCHDao.Include include = RecommendedQueriesCHDao.Include.BOTH;

    public Long getRegionId() {
        return regionId;
    }

    @Description("регион")
    @RequestQueryProperty()
    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public RecommendedQueriesCHDao.Include getInclude() {
        return include;
    }

    @Description("Какие запросы включать в результат -- с показами, без показов, или все (по умолчанию).")
    @RequestQueryProperty
    public void setInclude(RecommendedQueriesCHDao.Include include) {
        this.include = include;
    }

    public RecommendedQueryField getOrderBy() {
        return orderBy;
    }

    @Description("Сортировать по полю (по умолчанию - прогнозируемое количество кликов FORECASTED_CLICKS)")
    @RequestQueryProperty()
    public void setOrderBy(RecommendedQueryField orderBy) {
        this.orderBy = orderBy;
    }

    public OrderBy.Direction getOrderDirection() {
        return orderDirection;
    }

    @Description("Порядок сортировки (по умолчанию по убыванию - DESC)")
    @RequestQueryProperty()
    public void setOrderDirection(OrderBy.Direction orderDirection) {
        this.orderDirection = orderDirection;
    }
}
