package ru.yandex.webmaster3.viewer.http.searchquery.regions;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchQueryRegionParentsResponse implements ActionResponse.NormalResponse {
    private final List<RegionWithParents> regions;

    public SearchQueryRegionParentsResponse(List<RegionWithParents> regions) {
        this.regions = regions;
    }

    public List<RegionWithParents> getRegions() {
        return regions;
    }

    public static class RegionWithParents {
        private final int regionId;
        private final List<RegionView> parents;

        public RegionWithParents(int regionId, List<RegionView> parents) {
            this.regionId = regionId;
            this.parents = parents;
        }

        public int getRegionId() {
            return regionId;
        }

        public List<RegionView> getParents() {
            return parents;
        }
    }

    public static class RegionView {
        private final int regionId;

        public RegionView(int regionId) {
            this.regionId = regionId;
        }

        public int getRegionId() {
            return regionId;
        }
    }
}