package ru.yandex.webmaster3.viewer.http.searchquery.regions;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.regions.RegionUtils;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author avhaliullin
 */
public class SearchQueryRegionsRequest extends AbstractUserVerifiedHostRequest {
    private String filter;
    private int regionId = RegionUtils.WHOLE_WORLD_REGION.getId();
    private DateTime fromDate;
    private DateTime toDate;

    public String getFilter() {
        return filter;
    }

    @Description("Фильтр по имени региона")
    @RequestQueryProperty(required = false)
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int getRegionId() {
        return regionId;
    }

    @Description("Родительский регион")
    @RequestQueryProperty(required = false)
    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public DateTime getFromDate() {
        return fromDate;
    }

    @RequestQueryProperty(required = false)
    public void setFromDate(DateTime fromDate) {
        this.fromDate = fromDate;
    }

    public DateTime getToDate() {
        return toDate;
    }

    @RequestQueryProperty(required = false)
    public void setToDate(DateTime toDate) {
        this.toDate = toDate;
    }
}
