package ru.yandex.webmaster3.viewer.http.searchquery.rivals;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.searchquery.statistic.DateRangeAware;

/**
 * Created by Oleg Bazdyrev on 14/11/2017.
 */
public class DownloadRivalsStatisticsRequest extends UsersVerifiedHostRequest implements DateRangeAware {

    private FileFormat exportFormat;
    private DateTime dateFrom;
    private DateTime dateTo;
    private DeviceType deviceType = DeviceType.ALL_DEVICES;
    private AggregatePeriod period;
    private String thematics = "";

    public DeviceType getDeviceType() {
        return deviceType;
    }

    @RequestQueryProperty
    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public FileFormat getExportFormat() {
        return exportFormat;
    }

    @Description("формат файла выгрузки")
    @RequestQueryProperty(required = true)
    public void setExportFormat(FileFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

    public String getThematics() {
        return thematics;
    }

    @RequestQueryProperty
    public void setThematics(String thematics) {
        this.thematics = thematics;
    }
}
