package ru.yandex.webmaster3.viewer.http.searchquery.rivals;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.viewer.http.searchquery.statistic.AbstractDeviceTypeRequest;
import ru.yandex.webmaster3.viewer.http.searchquery.statistic.DateRangeAware;

/**
 * @author aherman
 */
public class GetRivalsStatisticsRequest extends AbstractDeviceTypeRequest implements DateRangeAware, PagerAware {

    private DateTime dateFrom;
    private DateTime dateTo;
    private AggregatePeriod period;
    private QueryIndicator[] indicator;
    private String thematics = "";
    private int page;
    private int pageSize = 20;

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public QueryIndicator[] getIndicator() {
        return indicator;
    }

    @RequestQueryProperty()
    public void setIndicator(QueryIndicator[] indicator) {
        this.indicator = indicator;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

    public String getThematics() {
        return thematics;
    }

    @RequestQueryProperty
    public void setThematics(String thematics) {
        this.thematics = thematics;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getP() {
        return page;
    }

    public int getPSize() {
        return pageSize;
    }

}
