package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;

import java.util.List;

/**
 * @author aherman
 */
public class AbstractQueryStatisticsResponse {
    public static class IndicatorStats {
        private final QueryIndicator name;
        private final List<GroupsStatisticResponse.RangeStat> ranges;

        public IndicatorStats(QueryIndicator name, List<GroupsStatisticResponse.RangeStat> ranges) {
            this.name = name;
            this.ranges = ranges;
        }

        public QueryIndicator getName() {
            return name;
        }

        public List<GroupsStatisticResponse.RangeStat> getRanges() {
            return ranges;
        }
    }

    public static class RangeStat {
        private final LocalDate dateFrom;
        private final LocalDate dateTo;
        private final Double value;
        private final Double difference;

        public RangeStat(LocalDate dateFrom, LocalDate dateTo, Double value, Double difference) {
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
            this.value = value;
            this.difference = difference;
        }

        public LocalDate getDateFrom() {
            return dateFrom;
        }

        public LocalDate getDateTo() {
            return dateTo;
        }

        public Double getValue() {
            return value;
        }

        public Double getDifference() {
            return difference;
        }
    }
}
