package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * @author aherman
 */
public interface DateRangeAware {
    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom);

    public DateTime getDateFrom();

    @JsonIgnore
    public default LocalDate getLocalDateFrom() {
        return getDateFrom().toLocalDate();
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo);

    public DateTime getDateTo();

    @JsonIgnore
    public default LocalDate getLocalDateTo() {
        return getDateTo().toLocalDate();
    }
}
