package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;
import org.joda.time.Months;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.request.RequestContext;

/**
 * @author aherman
 */
public class DateRangeRequestFilter implements RequestFilter<DateRangeAware, DateRangeRequestFilterResponse> {
    public static final int MAXIMUM_RANGE_IN_MONTH = 36;

    @Override
    public DateRangeRequestFilterResponse beforeRequest(RequestContext ctx, DateRangeAware req) {
        DateTime now = DateTime.now();
        DateTime dateFrom = req.getDateFrom();
        DateTime dateTo = req.getDateTo();

        if (dateFrom != null) {
            if (dateFrom.isAfter(now)) {
                return new DateRangeRequestFilterResponse.IllegalDateRange(this.getClass(),
                        "dateFrom",
                        dateFrom.toString());
            }
        }
        if (dateTo != null) {
            if (dateTo.isAfter(now)) {
                return new DateRangeRequestFilterResponse.IllegalDateRange(this.getClass(),
                        "dateTo",
                        dateTo.toString());
            }
        }
        if (dateFrom != null && dateTo != null) {
            if (Months.monthsBetween(dateFrom, dateTo).getMonths() > MAXIMUM_RANGE_IN_MONTH) {
                return new DateRangeRequestFilterResponse.IllegalDateRange(this.getClass(),
                        "dateFrom",
                        dateFrom.toString());
            }
        }
        return null;
    }
}
