package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import lombok.EqualsAndHashCode;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
@EqualsAndHashCode(callSuper = true)
public class GetGroupHistoryRequest extends AbstractDeviceTypeRequest implements DateRangeAware {
    private DateTime dateFrom;
    private DateTime dateTo;
    private AggregatePeriod period;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;

    private String[] groupId = {""};
    private QueryIndicator[] indicator;

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public QueryIndicator[] getIndicator() {
        return indicator;
    }

    @RequestQueryProperty(required = true)
    public void setIndicator(QueryIndicator[] indicator) {
        this.indicator = indicator;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }

    public String[] getGroupId() {
        return groupId;
    }

    @RequestQueryProperty
    public void setGroupId(String[] groupId) {
        this.groupId = groupId;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }
}
