package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
public class GetGroupStatisticsRequest extends AbstractDeviceTypeRequest implements DateRangeAware {
    private DateTime dateFrom;
    private DateTime dateTo;
    private AggregatePeriod period;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private int maxRanges = 5;
    private QueryIndicator orderBy;
    private OrderDirection orderDirection = OrderDirection.DESC;
    private boolean specialFirst = true;

    private QueryIndicator[] indicator;
    private String groupId;

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public QueryIndicator[] getIndicator() {
        return indicator;
    }

    @RequestQueryProperty()
    public void setIndicator(QueryIndicator[] indicator) {
        this.indicator = indicator;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }

    public String getGroupId() {
        return groupId;
    }

    @RequestQueryProperty
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

    public int getMaxRanges() {
        return maxRanges;
    }

    @RequestQueryProperty
    public void setMaxRanges(int maxRanges) {
        this.maxRanges = maxRanges;
    }

    public QueryIndicator getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(QueryIndicator orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public boolean isSpecialFirst() {
        return specialFirst;
    }

    @RequestQueryProperty
    public void setSpecialFirst(boolean specialFirst) {
        this.specialFirst = specialFirst;
    }
}
