package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
public class GetQueriesIndicatorRequest extends AbstractDeviceTypeRequest implements PagerAware, DateRangeAware {
    private QueryIndicator indicator;
    private String[] queryId;
    private DateTime dateFrom;
    private DateTime dateTo;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private AggregatePeriod period;
    private SpecialGroup specialGroup;
    private QueryIndicator orderBy = QueryIndicator.TOTAL_CLICKS_COUNT;
    private OrderDirection orderDirection = OrderDirection.DESC;
    private int maxRanges = 5;

    private int page;
    private int pageSize = 25;

    public QueryIndicator getIndicator() {
        return indicator;
    }

    @RequestQueryProperty(required = true)
    public void setIndicator(QueryIndicator indicator) {
        this.indicator = indicator;
    }

    public String[] getQueryId() {
        return queryId;
    }

    @RequestQueryProperty
    public void setQueryId(String[] queryId) {
        this.queryId = queryId;
    }

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    @RequestQueryProperty(required = true)
    public void setSpecialGroup(SpecialGroup specialGroup) {
        this.specialGroup = specialGroup;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public QueryIndicator getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(QueryIndicator orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public int getMaxRanges() {
        return maxRanges;
    }

    @RequestQueryProperty
    public void setMaxRanges(int maxRanges) {
        this.maxRanges = maxRanges;
    }
}
