package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
public class GetQueryHistoryRequest extends AbstractDeviceTypeRequest implements DateRangeAware {
    private DateTime dateFrom;
    private DateTime dateTo;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private QueryIndicator[] indicator;
    private String[] queryId;
    private SpecialGroup specialGroup;
    private AggregatePeriod period;

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public QueryIndicator[] getIndicator() {
        return indicator;
    }

    @RequestQueryProperty(required = true)
    public void setIndicator(QueryIndicator[] indicator) {
        this.indicator = indicator;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }

    public String[] getQueryId() {
        return queryId;
    }

    @RequestQueryProperty(required = true)
    public void setQueryId(String[] queryId) {
        this.queryId = queryId;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    @RequestQueryProperty(required = true)
    public void setSpecialGroup(SpecialGroup specialGroup) {
        this.specialGroup = specialGroup;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

}
