package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
public class GetQueryListStatisticsRequest extends AbstractDeviceTypeRequest implements PagerAware, DateRangeAware {
    private DateTime dateFrom;
    private DateTime dateTo;
    private int page;
    private int pageSize = 25;
    private SpecialGroup specialGroup;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private String[] queryId;
    private QueryIndicator[] indicator;
    private QueryIndicator orderBy = QueryIndicator.TOTAL_SHOWS_COUNT;
    private OrderDirection orderDirection = OrderDirection.DESC;

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    @RequestQueryProperty(required = true)
    public void setSpecialGroup(SpecialGroup specialGroup) {
        this.specialGroup = specialGroup;
    }

    public String[] getQueryId() {
        return queryId;
    }

    @RequestQueryProperty
    public void setQueryId(String[] queryId) {
        this.queryId = queryId;
    }

    public QueryIndicator[] getIndicator() {
        return indicator;
    }

    @RequestQueryProperty(required = true)
    public void setIndicator(QueryIndicator[] indicator) {
        this.indicator = indicator;
    }

    public QueryIndicator getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(QueryIndicator orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }
}
