package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQuery;

/**
 * @author aherman
 */
public abstract class GetQueryListStatisticsResponse extends AbstractQueryStatisticsResponse implements ActionResponse {
    public static class NormalResponse extends GetQueryListStatisticsResponse implements ActionResponse.NormalResponse {
        private final long queriesCount;
        private final long itemsCount;
        private final List<QueryStat> statistics;

        public NormalResponse(long queriesCount, List<QueryStat> statistics) {
            this.queriesCount = queriesCount;
            this.itemsCount = queriesCount;
            this.statistics = statistics;
        }

        public long getItemsCount() {
            return itemsCount;
        }

        public long getQueriesCount() {
            return queriesCount;
        }

        public List<QueryStat> getStatistics() {
            return statistics;
        }
    }

    public static class QueryStat {
        private final ViewerQuery query;
        private final List<IndicatorStats> indicators;

        public QueryStat(ViewerQuery query, List<IndicatorStats> indicators) {
            this.query = query;
            this.indicators = indicators;
        }

        public ViewerQuery getQuery() {
            return query;
        }

        public List<IndicatorStats> getIndicators() {
            return indicators;
        }
    }
}
