package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.DateTime;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.storage.searchquery.AggregatePeriod;
import ru.yandex.webmaster3.storage.searchquery.RegionInclusion;

/**
 * @author aherman
 */
public class GetSelectedQueryRequest extends AbstractDeviceTypeRequest implements DateRangeAware {
    private String queryId;
    private DateTime dateFrom;
    private DateTime dateTo;
    private Integer[] regionId;
    private RegionInclusion regionInclusion = RegionInclusion.INCLUDE_ALL;
    private AggregatePeriod period;
    private SpecialGroup specialGroup;
    private int maxRanges = 5;

    public String getQueryId() {
        return queryId;
    }

    @RequestQueryProperty(required = true)
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public DateTime getDateFrom() {
        return dateFrom;
    }

    @RequestQueryProperty(required = true)
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public DateTime getDateTo() {
        return dateTo;
    }

    @RequestQueryProperty(required = true)
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public Integer[] getRegionId() {
        return regionId;
    }

    @RequestQueryProperty
    public void setRegionId(Integer[] regionId) {
        this.regionId = regionId;
    }

    public RegionInclusion getRegionInclusion() {
        return regionInclusion;
    }

    @RequestQueryProperty
    public void setRegionInclusion(RegionInclusion regionInclusion) {
        this.regionInclusion = regionInclusion;
    }

    public AggregatePeriod getPeriod() {
        return period;
    }

    @RequestQueryProperty(required = true)
    public void setPeriod(AggregatePeriod period) {
        this.period = period;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    @RequestQueryProperty(required = true)
    public void setSpecialGroup(SpecialGroup specialGroup) {
        this.specialGroup = specialGroup;
    }

    public int getMaxRanges() {
        return maxRanges;
    }

    @RequestQueryProperty
    public void setMaxRanges(int maxRanges) {
        this.maxRanges = maxRanges;
    }
}
