package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.searchquery.SearchqueryDatesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@ReadAction
@Category("searchquery")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetStatisticDatesAction extends AbstractUserVerifiedHostAction<GetStatisticDatesRequest, GetStatisticDatesResponse> {

    private final SearchqueryDatesService searchqueryDatesService;

    @Override
    public GetStatisticDatesResponse process(GetStatisticDatesRequest request) {
        var dates = searchqueryDatesService.getDatesCached(request.getHostId());
        return new GetStatisticDatesResponse.NormalResponse(dates.getLeft(), dates.getRight());
    }
}
