package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class GetStatisticDatesResponse implements ActionResponse {
    public static class NormalResponse extends GetStatisticDatesResponse implements ActionResponse.NormalResponse {
        private final LocalDate minimumDate;
        private final LocalDate maximumDate;

        public NormalResponse(LocalDate minimumDate, LocalDate maximumDate) {
            this.minimumDate = minimumDate;
            this.maximumDate = maximumDate;
        }

        public LocalDate getMinimumDate() {
            return minimumDate;
        }

        public LocalDate getMaximumDate() {
            return maximumDate;
        }
    }
}
