package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerPath;

import java.util.List;

/**
 * @author lester
 */
public abstract class GetUrlListStatisticsResponse extends AbstractQueryStatisticsResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlListStatisticsResponse implements ActionResponse.NormalResponse {
        private final long pathsCount;
        private final long itemsCount;
        private final List<PathStat> statistics;

        public NormalResponse(long pathsCount, List<PathStat> statistics) {
            this.pathsCount = pathsCount;
            this.statistics = statistics;
            this.itemsCount = pathsCount;
        }

        public long getPathsCount() {
            return pathsCount;
        }

        public long getItemsCount() {
            return itemsCount;
        }

        public List<PathStat> getStatistics() {
            return statistics;
        }
    }

    public static class PathStat {
        private final ViewerPath path;
        private final List<IndicatorStats> indicators;

        public PathStat(ViewerPath path, List<IndicatorStats> indicators) {
            this.path = path;
            this.indicators = indicators;
        }

        public ViewerPath getPath() {
            return path;
        }

        public List<IndicatorStats> getIndicators() {
            return indicators;
        }
    }
}
