package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import ru.yandex.webmaster3.core.searchquery.QueryIndicator;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryGroup;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * @author aherman
 */
public class GroupComparators {
    public static Comparator<GroupsStatisticResponse.GroupStat> SPECIAL_GROUP_FIRST =
            Comparator.comparing(GroupsStatisticResponse.GroupStat::getGroup, ViewerQueryGroup.SPECIAL_GROUPS_FIRST);

    public static Comparator<GroupsStatisticResponse.GroupStat> comparatorByIndicator(QueryIndicator orderBy) {
        boolean dynamics = orderBy.isDynamics();
        QueryIndicator orderIndicator = dynamics ? orderBy.getDynamicsOf() : orderBy;
        return (g1, g2) -> {
            Optional<GroupsStatisticResponse.IndicatorStats> i1O =
                    g1.getIndicators().stream().filter(i -> i.getName() == orderIndicator).findFirst();
            Optional<GroupsStatisticResponse.IndicatorStats> i2O =
                    g2.getIndicators().stream().filter(i -> i.getName() == orderIndicator).findFirst();
            if (!i1O.isPresent() || !i2O.isPresent()) {
                return 0;
            }

            List<GroupsStatisticResponse.RangeStat> r1 = i1O.get().getRanges();
            List<GroupsStatisticResponse.RangeStat> r2 = i2O.get().getRanges();
            return compareRanges(r1, r2, dynamics);
        };
    }

    public static Comparator<GroupsStatisticResponse.GroupStat> comparatorByIndicator() {
        return (g1, g2) -> {
            List<GroupsStatisticResponse.RangeStat> r1 = g1.getIndicator().getRanges();
            List<GroupsStatisticResponse.RangeStat> r2 = g2.getIndicator().getRanges();
            return compareRanges(r1, r2, false);
        };
    }

    private static int compareRanges(List<GroupsStatisticResponse.RangeStat> r1,
            List<GroupsStatisticResponse.RangeStat> r2, boolean dynamics)
    {
        if (r1.isEmpty()) {
            if (r2.isEmpty()) {
                return 0;
            } else {
                return -1;
            }
        } else if (r2.isEmpty()) {
            return 1;
        }
        Double v1 = dynamics ? r1.get(0).getDifference() : r1.get(0).getValue();
        Double v2 = dynamics ? r2.get(0).getDifference() : r2.get(0).getValue();
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            } else {
                return -1;
            }
        } else if (v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }
}
