package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import java.util.List;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryGroup;

/**
 * @author aherman
 */
public abstract class GroupsStatisticResponse extends AbstractQueryStatisticsResponse implements ActionResponse {
    public static class NormalResponse extends GroupsStatisticResponse implements ActionResponse.NormalResponse {
        private final List<DateRange> ranges;
        private final List<GroupStat> statistics;

        public NormalResponse(List<DateRange> ranges, List<GroupStat> statistics) {
            this.ranges = ranges;
            this.statistics = statistics;
        }

        public List<DateRange> getRanges() {
            return ranges;
        }

        public List<GroupStat> getStatistics() {
            return statistics;
        }
    }

    public static class GroupStat {
        private final ViewerQueryGroup group;
        private final IndicatorStats indicator;
        private final List<IndicatorStats> indicators;

        public GroupStat(ViewerQueryGroup group, IndicatorStats indicator) {
            this.group = group;
            this.indicator = indicator;
            this.indicators = null;
        }

        public GroupStat(ViewerQueryGroup group, List<IndicatorStats> indicators) {
            this.group = group;
            this.indicator = null;
            this.indicators = indicators;
        }

        public ViewerQueryGroup getGroup() {
            return group;
        }

        public IndicatorStats getIndicator() {
            return indicator;
        }

        public List<IndicatorStats> getIndicators() {
            return indicators;
        }
    }

    public static class DateRange {
        private final LocalDate dateFrom;
        private final LocalDate dateTo;
        private final boolean wholeUserRange;

        public DateRange(LocalDate dateFrom, LocalDate dateTo, boolean wholeUserRange) {
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
            this.wholeUserRange = wholeUserRange;
        }

        public LocalDate getDateFrom() {
            return dateFrom;
        }

        public LocalDate getDateTo() {
            return dateTo;
        }

        public boolean isWholeUserRange() {
            return wholeUserRange;
        }
    }
}
