package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import java.util.List;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQuery;

/**
 * @author aherman
 */
public abstract class QueryStatisticsResponse extends AbstractQueryStatisticsResponse implements ActionResponse{
    public static class NormalResponse extends QueryStatisticsResponse implements ActionResponse.NormalResponse {
        private final Integer queriesCount;
        private final Integer itemsCount;
        private final List<DateRange> ranges;
        private final List<QueryStat> statistics;

        public NormalResponse(Integer queriesCount, List<DateRange> ranges, List<QueryStat> statistics) {
            this.queriesCount = queriesCount;
            this.itemsCount = queriesCount;
            this.ranges = ranges;
            this.statistics = statistics;
        }

        public Integer getQueriesCount() {
            return queriesCount;
        }

        public Integer getItemsCount() {
            return itemsCount;
        }

        public List<DateRange> getRanges() {
            return ranges;
        }

        public List<QueryStat> getStatistics() {
            return statistics;
        }
    }

    public static class QueryStat {
        private final ViewerQuery query;
        private final IndicatorStats indicator;

        public QueryStat(ViewerQuery query, IndicatorStats indicator) {
            this.query = query;
            this.indicator = indicator;
        }

        public ViewerQuery getQuery() {
            return query;
        }

        public IndicatorStats getIndicator() {
            return indicator;
        }
    }

    public static class DateRange {
        private final LocalDate dateFrom;
        private final LocalDate dateTo;
        private final boolean wholeUserRange;

        public DateRange(LocalDate dateFrom, LocalDate dateTo, boolean wholeUserRange) {
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
            this.wholeUserRange = wholeUserRange;
        }

        public LocalDate getDateFrom() {
            return dateFrom;
        }

        public LocalDate getDateTo() {
            return dateTo;
        }

        public boolean isWholeUserRange() {
            return wholeUserRange;
        }
    }

}
