package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.searchquery.QueryStatisticsService2;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author aherman
 */
@ReadAction
@Category("searchquery")
public class SuggestQueryAction extends AbstractUserVerifiedHostAction<SuggestQueryRequest, SuggestQueryResponse> {
    private QueryStatisticsService2 queryStatisticsService2;

    @Override
    public SuggestQueryResponse process(SuggestQueryRequest request) throws WebmasterException {
        String queryFilter = StringUtils.trimToEmpty(request.getQueryFilter());
        List<SuggestQueryResponse.Query> result =
                queryStatisticsService2.suggestQuery(request.getHostId(), request.getSpecialGroup(),
                        queryFilter, request.getPageSize())
                        .stream()
                        .map(q -> new SuggestQueryResponse.Query(q.getQueryId().toStringId(), q.getQuery()))
                        .collect(Collectors.toList());

        return new SuggestQueryResponse(result);
    }

    @Required
    public void setQueryStatisticsService2(QueryStatisticsService2 queryStatisticsService2) {
        this.queryStatisticsService2 = queryStatisticsService2;
    }

}
