package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public class SuggestQueryResponse implements ActionResponse.NormalResponse {
    private final List<Query> queries;

    public SuggestQueryResponse(List<Query> queries) {
        this.queries = queries;
    }

    public List<Query> getQueries() {
        return queries;
    }

    public static class Query {
        private final String queryId;
        private final String query;

        public Query(String queryId, String query) {
            this.queryId = queryId;
            this.query = query;
        }

        public String getQueryId() {
            return queryId;
        }

        public String getQuery() {
            return query;
        }
    }
}
