package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.searchquery.UrlStatisticsService2;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lester
 */
@ReadAction
@Category("searchquery")
public class SuggestUrlAction extends AbstractUserVerifiedHostAction<SuggestUrlRequest, SuggestUrlResponse> {
    @Autowired
    private UrlStatisticsService2 urlStatisticsService2;

    @Override
    public SuggestUrlResponse process(SuggestUrlRequest request) throws WebmasterException {
        String pathFilter = StringUtils.trimToEmpty(request.getPathFilter());
        List<SuggestUrlResponse.Path> result =
                urlStatisticsService2.suggestPath(request.getHostId(), request.getSpecialGroup(),
                        pathFilter, request.getPageSize())
                        .stream()
                        .map(q -> new SuggestUrlResponse.Path(q.getPathId().toStringId(), q.getPath()))
                        .collect(Collectors.toList());

        return new SuggestUrlResponse(result);
    }

}
