package ru.yandex.webmaster3.viewer.http.searchquery.statistic;

import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerPath;

import java.util.List;

/**
 * @author lester
 */
public abstract class UrlStatisticsResponse extends AbstractQueryStatisticsResponse implements ActionResponse{
    public static class NormalResponse extends UrlStatisticsResponse implements ActionResponse.NormalResponse {
        private final Integer pathsCount;
        private final Integer itemsCount;
        private final List<DateRange> ranges;
        private final List<PathStat> statistics;

        public NormalResponse(Integer pathsCount, List<DateRange> ranges, List<PathStat> statistics) {
            this.pathsCount = pathsCount;
            this.ranges = ranges;
            this.statistics = statistics;
            this.itemsCount = pathsCount;
        }

        public Integer getPathsCount() {
            return pathsCount;
        }

        public Integer getItemsCount() {
            return itemsCount;
        }

        public List<DateRange> getRanges() {
            return ranges;
        }

        public List<PathStat> getStatistics() {
            return statistics;
        }
    }

    public static class PathStat {
        private final ViewerPath path;
        private final IndicatorStats indicator;

        public PathStat(ViewerPath path, IndicatorStats indicator) {
            this.path = path;
            this.indicator = indicator;
        }

        public ViewerPath getPath() {
            return path;
        }

        public IndicatorStats getIndicator() {
            return indicator;
        }
    }

    public static class DateRange {
        private final LocalDate dateFrom;
        private final LocalDate dateTo;
        private final boolean wholeUserRange;

        public DateRange(LocalDate dateFrom, LocalDate dateTo, boolean wholeUserRange) {
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
            this.wholeUserRange = wholeUserRange;
        }

        public LocalDate getDateFrom() {
            return dateFrom;
        }

        public LocalDate getDateTo() {
            return dateTo;
        }

        public boolean isWholeUserRange() {
            return wholeUserRange;
        }
    }
}
