package ru.yandex.webmaster3.viewer.http.searchurl.events;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlEventType;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchUrlEventHistoryResponse implements ActionResponse.NormalResponse, DateHistory<SearchUrlEventType> {
    private final List<SearchUrlHistory> histories;

    public SearchUrlEventHistoryResponse(List<SearchUrlHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<SearchUrlHistory> getHistories() {
        return histories;
    }

    public static class SearchUrlHistory implements DateHistory.History<SearchUrlEventType> {
        private final SearchUrlEventType indicator;
        private final List<DatePoint> data;

        public SearchUrlHistory(SearchUrlEventType indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public SearchUrlEventType getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
