package ru.yandex.webmaster3.viewer.http.searchurl.events;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.UserContext;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.searchbase.SearchBaseUpdatesService;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlSamplesService;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.SearchUrlEventConditions;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlEventSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;

import java.util.Collections;
import java.util.List;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Посмотреть примеры событий, которые происходили со страницами в последних поисковых базах")
@Category("searchurl")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SearchUrlEventSamplesAction extends AbstractUrlFilteringAction<SearchUrlEventSamplesRequest, SearchUrlEventSamplesResponse> {
    @Setter
    protected SearchUrlSamplesService searchUrlSamplesService;
    @Setter
    protected SearchBaseUpdatesService searchBaseUpdatesService;
    @Setter
    protected SearchUrlEventConditions searchUrlEventConditions;

    @Override
    public SearchUrlEventSamplesResponse process(SearchUrlEventSamplesRequest request) throws WebmasterException {
        UserContext.setUserId(request.getUserId());
        Condition condition = searchUrlEventConditions.makeCondition(request.getHostId(), request.getParameterFilters(), false,
                searchBaseUpdatesService.getSearchBaseUpdates());
        Condition freshCondition = searchUrlEventConditions.makeCondition(request.getHostId(), request.getParameterFilters(), true,
                searchBaseUpdatesService.getSearchBaseUpdates());
        condition = condition.andThen(getNodeCondition(request.getNodeId(), request.getHostId(), SearchUrlEventConditions::buildPathCondition));
        long samplesCount = searchUrlSamplesService.getSearchUrlEventSamplesCount(
                request.getHostId(),
                condition, freshCondition
        );
        if (samplesCount == 0) {
            return new SearchUrlEventSamplesResponse(samplesCount, Collections.emptyList());
        }
        List<SearchUrlEventSample> samples = searchUrlSamplesService.getSearchUrlEventSamples(request.getHostId(), condition, freshCondition,
                request.getP() * request.getPSize(), request.getPSize());


        return new SearchUrlEventSamplesResponse(samplesCount, samples);
    }

}
