package ru.yandex.webmaster3.viewer.http.searchurl.events;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlEventSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchUrlEventSamplesResponse implements ActionResponse.NormalResponse {
    private final long totalSamples;
    private final List<SearchUrlEventSample> samples;

    public SearchUrlEventSamplesResponse(long totalSamples, List<SearchUrlEventSample> samples) {
        this.totalSamples = totalSamples;
        this.samples = samples;
    }

    @Description("количество доступных примеров")
    public long getTotalSamples() {
        return totalSamples;
    }

    @Description("примеры событий со страницами в поиске")
    public List<SearchUrlEventSample> getSamples() {
        return samples;
    }
}
