package ru.yandex.webmaster3.viewer.http.searchurl.events;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.metrika.counters.MetrikaCountersUtil;
import ru.yandex.webmaster3.storage.metrika.MetrikaCrawlStateService;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlSamplesService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author leonidrom
 */
@Description("Получить количество урлов, найденных по счетчикам с момента последнего обхода")
@ReadAction
@Category("searchurl")
@Component("/dashboard/searchurl/event/validFromMetrikaCount")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SearchUrlValidFromMetrikaCountDashboardAction extends Action<SearchUrlValidFromMetrikaCountDashboardAction.Req, SearchUrlValidFromMetrikaCountDashboardAction.Resp> {
    private final MetrikaCrawlStateService metrikaCrawlStateService;
    private final SearchUrlSamplesService searchUrlSamplesService;

    @Override
    public Resp process(Req req) throws WebmasterException {
        String domain = MetrikaCountersUtil.hostToPunycodeDomain(req.getHostId());
        if (!metrikaCrawlStateService.getDomainCrawlStateCached(domain).hasEnabled()) {
            return new Resp(0);
        }

        return new Resp(searchUrlSamplesService.getValidFromMetrikaNewEventSamplesCount(req.getHostId()));
    }

    public static class Req extends AbstractUserVerifiedHostRequest {
    }

    public static class Resp implements ActionResponse.NormalResponse {
        private final long totalUrls;

        private Resp(long totalUrls) {
            this.totalUrls = totalUrls;
        }

        @Description("Количество урлов, найденных по счетчикам с момента последнего обхода")
        public long getTotalUrls() {
            return totalUrls;
        }
    }
}
