package ru.yandex.webmaster3.viewer.http.searchurl.excluded;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.sitestructure.NewSiteStructure;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.SiteTreeNodeAware;
import ru.yandex.webmaster3.viewer.http.searchurl.filter.SearchUrlDateRangeAware;

/**
 * @author avhaliullin
 */
public class ExcludedUrlHistoryRequest extends AbstractUserVerifiedHostRequest implements SiteTreeNodeAware, SearchUrlDateRangeAware {
    private long nodeId = NewSiteStructure.ROOT_NODE_ID;
    private Instant dateFrom;
    private Instant dateTo;

    @Override
    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public void setDateFrom(Instant dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public Long getNodeId() {
        return nodeId;
    }

    @Override
    public Instant getDateFrom() {
        return dateFrom;
    }

    @Override
    public void setDateTo(Instant dateTo) {
        this.dateTo = dateTo;
        ;
    }

    @Override
    public Instant getDateTo() {
        return dateTo;
    }
}
