package ru.yandex.webmaster3.viewer.http.searchurl.excluded;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ExcludedUrlHistoryResponse implements ActionResponse.NormalResponse, DateHistory<SearchUrlStatusEnum> {
    private final List<ExcludedUrlHistory> histories;

    public ExcludedUrlHistoryResponse(List<ExcludedUrlHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<ExcludedUrlHistory> getHistories() {
        return histories;
    }

    public static class ExcludedUrlHistory implements History<SearchUrlStatusEnum> {
        private final SearchUrlStatusEnum indicator;
        private final List<DatePoint> data;

        public ExcludedUrlHistory(SearchUrlStatusEnum indicator, List<DatePoint> data) {
            this.indicator = indicator;
            this.data = data;
        }

        @Override
        public SearchUrlStatusEnum getIndicatorName() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
