package ru.yandex.webmaster3.viewer.http.searchurl.excluded;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.UserContext;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitestructure.RawSearchUrlStatusEnum;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusUtil;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.TextFilterUtil;
import ru.yandex.webmaster3.storage.searchurl.ExcludedUrlSampleField;
import ru.yandex.webmaster3.storage.searchurl.SearchUrlSamplesService;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.ExcludedUrlConditions;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.IntCondition;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Operator;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;

import static ru.yandex.webmaster3.storage.searchurl.samples.dao.ExcludedUrlConditions.getSitemapFieldName;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.ExcludedUrlConditions.getTurboFieldName;

/**
 * @author avhaliullin
 */
@ReadAction
@Description("Посмотреть примеры исключенных из поиска урлов")
@Category("searchurl")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ExcludedUrlSamplesAction extends AbstractUrlFilteringAction<ExcludedUrlSamplesRequest, ExcludedUrlSamplesResponse> {
    private final SearchUrlSamplesService searchUrlSamplesService;
    private final ExcludedUrlConditions excludedUrlConditions;

    @Override
    public ExcludedUrlSamplesResponse process(ExcludedUrlSamplesRequest request) throws WebmasterException {
        Condition condition = excludedUrlConditions.makeCondition(request.getHostId(), request.getParameterFilters(), false);
        UserContext.setUserId(request.getUserId());
        condition = condition.andThen(getNodeCondition(request.getNodeId(), request.getHostId(), ExcludedUrlConditions::buildPathCondition));
        long samplesCount = searchUrlSamplesService.getExcludedUrlSamplesCount(
                request.getHostId(),
                condition, Condition.falseCondition()
        );
        if (samplesCount == 0) {
            return new ExcludedUrlSamplesResponse(samplesCount, Collections.emptyList());
        }
        List<SearchUrlSample> samples = searchUrlSamplesService.getExcludedUrlSamples(request.getHostId(), condition, Condition.falseCondition(),
                request.getP() * request.getPSize(), request.getPSize());
        return new ExcludedUrlSamplesResponse(samplesCount, samples);
    }
}
