package ru.yandex.webmaster3.viewer.http.searchurl.excluded;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ExcludedUrlSamplesResponse implements ActionResponse.NormalResponse {
    private final long totalSamples;
    private final List<SearchUrlSample> samples;

    public ExcludedUrlSamplesResponse(long totalSamples, List<SearchUrlSample> samples) {
        this.totalSamples = totalSamples;
        this.samples = samples;
    }

    @Description("количество доступных примеров")
    public long getTotalSamples() {
        return totalSamples;
    }

    @Description("примеры исключенных страниц")
    public List<SearchUrlSample> getSamples() {
        return samples;
    }
}
