package ru.yandex.webmaster3.viewer.http.searchurl.excluded;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ExcludedUrlStatusesResponse implements ActionResponse.NormalResponse {
    private final List<StatusInfo> statuses;

    public ExcludedUrlStatusesResponse(List<StatusInfo> statuses) {
        this.statuses = statuses;
    }

    @Description("список статусов")
    public List<StatusInfo> getStatuses() {
        return statuses;
    }

    public static class StatusInfo {
        private final SearchUrlStatusEnum status;
        private final List<Integer> httpCodes;

        public StatusInfo(SearchUrlStatusEnum status, List<Integer> httpCodes) {
            this.status = status;
            this.httpCodes = httpCodes;
        }

        @Description("статус")
        public SearchUrlStatusEnum getStatus() {
            return status;
        }

        @Description("список http-кодов, которыми можно дополнять фильтрацию по этому статусу")
        public List<Integer> getHttpCodes() {
            return httpCodes;
        }
    }
}
