package ru.yandex.webmaster3.viewer.http.searchurl.memorandum;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.searchurl.MemorandumStatsYDao;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("searchurl")
@Description("Сводная информация о забанах на хосте в рамках меморандума")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/searchurl/memorandum/info")
public class HostMemorandumInfoAction extends Action<HostMemorandumInfoRequest, HostMemorandumInfoResponse> {

    private final MemorandumStatsYDao memorandumStatsYDao;

    @Override
    public HostMemorandumInfoResponse process(HostMemorandumInfoRequest request) {
        return new HostMemorandumInfoResponse(memorandumStatsYDao.getBannedUrlsCount(request.getHostId()));
    }

}
