package ru.yandex.webmaster3.viewer.http.searchurl.memorandum;

import lombok.Setter;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.host.HostDataState;
import ru.yandex.webmaster3.storage.host.service.HostService;
import ru.yandex.webmaster3.storage.searchurl.samples.MemorandumSamplesService;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.MemorandumConditions;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.SearchUrlConditions;
import ru.yandex.webmaster3.storage.searchurl.samples.data.MemorandumSample;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;

import java.util.Collections;
import java.util.List;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("searchurl")
@Description("Примеры забаненых урлов")
public class MemorandumBannedSamplesAction extends AbstractUrlFilteringAction<MemorandumBannedSamplesRequest, MemorandumBannedSamplesResponse> {

    @Setter
    private MemorandumSamplesService memorandumSamplesService;

    @Override
    public MemorandumBannedSamplesResponse process(MemorandumBannedSamplesRequest request) throws WebmasterException {
        Condition condition = MemorandumConditions.makeCondition(request.getParameterFilters())
                .andThen(getNodeCondition(request.getNodeId(), request.getHostId(), SearchUrlConditions::buildPathCondition));
        long samplesCount = memorandumSamplesService.getSamplesCount(
                request.getHostId(),
                condition
        );
        if (samplesCount == 0) {
            return new MemorandumBannedSamplesResponse(samplesCount, Collections.emptyList());
        }
        List<MemorandumSample> samples = memorandumSamplesService.getSamples(request.getHostId(), condition,
                request.getP() * request.getPSize(), request.getPSize());
        return new MemorandumBannedSamplesResponse(samplesCount, samples);
    }

}
