package ru.yandex.webmaster3.viewer.http.searchurl.memorandum;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.storage.searchurl.MemorandumFilter;
import ru.yandex.webmaster3.viewer.http.SiteTreeNodeAware;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MemorandumBannedSamplesRequest extends UsersVerifiedHostRequest implements SiteTreeNodeAware, PagerAware {
    private int p;
    private int pSize = 10;
    private Long nodeId;
    private List<MemorandumFilter> parameterFilters;

    public int getP() {
        return p;
    }

    @Override
    public void setP(int p) {
        this.p = p;
    }

    public int getPSize() {
        return pSize;
    }

    @Override
    public void setPSize(int pSize) {
        this.pSize = pSize;
    }

    @Override
    public Long getNodeId() {
        return nodeId;
    }

    @Override
    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public List<MemorandumFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по примерам")
    @RequestPostProperty
    public void setParameterFilters(List<MemorandumFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }
}
